let cachedNotesData = {};

function requestNotes() {
    return new Promise((resolve, reject) => {
        chrome.runtime.sendMessage(
            { type: "GET_NOTES" },
            (response) => {
                if (response && response.success) {
                    cachedNotesData = response.data;
                    resolve();
                } else {
                    reject(response?.error || "Failed to load notes");
                }
            }
        );
    });
}

function displayNotes() {
    const makeAppBranchElement = document.querySelector('make-app-branch');
    if (!makeAppBranchElement) return;

    const matRadioGroupElement = makeAppBranchElement.querySelector('.mat-radio-group');
    if (!matRadioGroupElement) return;

    let selectedLabelContent = null;
    let selectedStandorte = [];

    const matRadioButtonElements = matRadioGroupElement.querySelectorAll('.mat-radio-button');

    matRadioButtonElements.forEach(button => {
        if (button.classList.contains('mat-radio-checked')) {
            const labelContentElement = button.querySelector('.mat-radio-label-content');

            if (labelContentElement) {
                selectedLabelContent = labelContentElement.textContent.trim();

                if (selectedLabelContent === "Standort wählen") {
                    const filterSearchElement = makeAppBranchElement.querySelector('filter-search');
                    const selectedOptionsContainer = filterSearchElement?.querySelector('.selected-options-container');
                    const selectedOptionItems = selectedOptionsContainer?.querySelectorAll('.selected-option-item');

                    selectedOptionItems?.forEach(item => {
                        selectedStandorte.push(item.textContent.trim());
                    });

                } else if (selectedLabelContent === "Alle Standorte") {
                    selectedStandorte = Object.keys(cachedNotesData);
                } else {
                    selectedStandorte = [selectedLabelContent];
                }
            }
        }
    });

    let existingNotesContainer = document.getElementById("notescontainer");
    if (existingNotesContainer) {
        existingNotesContainer.remove();
    }

    const notesContainer = document.createElement('div');
    notesContainer.id = "notescontainer";

    selectedStandorte.forEach(standort => {
        if (cachedNotesData[standort]) {
            const notesSection = document.createElement('div');

            const notesTitle = document.createElement('h3');
            notesTitle.classList.add('hob-whatToDo-title');
            notesTitle.textContent = `Hinweise zu ${standort}`;

            const notesList = document.createElement('ul');

            cachedNotesData[standort].forEach(note => {
                const li = document.createElement('li');
                li.textContent = note;
                notesList.appendChild(li);
            });

            notesSection.appendChild(notesTitle);
            notesSection.appendChild(notesList);
            notesContainer.appendChild(notesSection);
        }
    });

    makeAppBranchElement.parentNode.insertBefore(
        notesContainer,
        makeAppBranchElement.nextSibling
    );
}

let lastRunTimestamp = 0;

function debounceDisplayNotes() {
    const now = Date.now();

    if (now - lastRunTimestamp >= 300) {
        lastRunTimestamp = now;
        setTimeout(displayNotes, 200);
    }
}

async function init() {
    try {
        await requestNotes();

        const observer = new MutationObserver(() => {
            debounceDisplayNotes();
        });

        observer.observe(document.body, {
            childList: true,
            subtree: true,
            attributes: true
        });

        debounceDisplayNotes();
    } catch (error) {
        console.error("Failed to initialize notes:", error);
    }
}

init();
